#!/bin/sh

title()
{
	echo -----------------------------------------
	echo "Install AAEON F81xxx WDT Driver."
	echo -----------------------------------------
}


title

echo "Check old driver and unload it."

check=`lsmod | grep -w iTCO_wdt`
if [ "$check" != "" ]; then
	echo "rmmod iTCO_wdt"
    modprobe -r iTCO_wdt
	sed -i '$d' /etc/rc.local
	echo modprobe -r iTCO_wdt >> /etc/rc.local
	echo exit 0 >> /etc/rc.local
fi

check=`lsmod | grep -w f81xxx_wdt`
if [ "$check" != "" ]; then
	echo "rmmod f81xxx_wdt"
    /sbin/rmmod f81xxx_wdt
fi


echo "Build the module and install."
echo "-------------------------------" >> log.txt
date 1>>log.txt
make all 1>>log.txt || exit 1

module=`ls driver/*.ko`
module=${module#driver/}
module=${module%.ko}

if [ "$module" = "" ]; then
	echo "No driver exists!!!"
	exit 1
else
	OLD_DRIVER=$(find /lib/modules/$(uname -r)/kernel/drivers/watchdog -iname f81xxx_wdt.ko -type f)
	BAK_DRIVER=$(find /lib/modules/$(uname -r)/kernel/drivers/watchdog -iname f81xxx_wdt.ko_bak -type f)
	TARGET_PATH=/lib/modules/$(uname -r)/kernel/drivers/watchdog
	
	if [ "$BAK_DRIVER" = "" ]; then
	
		if [ "$OLD_DRIVER" = "" ]; then
			cp driver/f81xxx_wdt.ko $TARGET_PATH/
		else
			mv $OLD_DRIVER $TARGET_PATH/f81xxx_wdt.ko_bak
			cp driver/f81xxx_wdt.ko $TARGET_PATH/
		fi
	
	else
		
		cp driver/f81xxx_wdt.ko $TARGET_PATH/
		
	fi
fi

echo "Update driver."
depmod -a

echo "Load module: $module ."
modprobe $module

#Add modprobe to init

echo "Add driver to init."
MODULE_INIT=$(grep -w "modprobe f81xxx_wdt" /etc/rc.local)
	
	if [ "$MODULE_INIT" = "" ]; then
		sed -i '$d' /etc/rc.local
		echo modprobe f81xxx_wdt >> /etc/rc.local
		echo exit 0 >> /etc/rc.local
	fi

chmod +x /etc/rc.local

echo "Completed."
exit 0

