#!/bin/sh

title()
{
	echo -----------------------------------------
	echo "Install PTN3460 Backlight Driver."
	echo -----------------------------------------
}

show_usage()
{
	echo "Usage:"
	echo "		./install.sh <I2C bus number>"
	echo
	echo "Ex:"
	echo "		I2C bus is i2c-9."
	echo "		command: ./install.sh 9"
	echo
}

if [ $# -eq 0 ] || [ $# -gt 1 ]; then
    echo "ERROR: incorrect number of parameters"
    show_usage
    exit 255
fi

title

echo "Check old driver and unload it."

check=`lsmod | grep -w ptn3460`
if [ "$check" != "" ]; then
    echo "Uninstall ptn3460"
    echo 0x60 > /sys/bus/i2c/devices/i2c-$1/delete_device
    /sbin/rmmod ptn3460
fi

echo "Build the module and install."
echo "-------------------------------" >> log.txt
date 1>>log.txt
make all 1>>log.txt || exit 1

module=`ls driver/*.ko`
module=${module#driver/}
module=${module%.ko}

if [ "$module" = "" ]; then
	echo "No driver exists!!!"
	exit 1
else
	OLD_DRIVER=$(find /lib/modules/$(uname -r)/kernel/drivers/gpu/drm/ -iname ptn3460.ko -type f)
	BAK_DRIVER=$(find /lib/modules/$(uname -r)/kernel/drivers/gpu/drm/ -iname ptn3460.ko_bak -type f)
	TARGET_PATH=/lib/modules/$(uname -r)/kernel/drivers/gpu/drm/
	
	if [ "$BAK_DRIVER" = "" ]; then
	
		if [ "$OLD_DRIVER" = "" ]; then
			cp driver/ptn3460.ko $TARGET_PATH/
		else
			mv $OLD_DRIVER $TARGET_PATH/ptn3460.ko_bak
			cp driver/ptn3460.ko $TARGET_PATH/
		fi
	
	else

		cp driver/ptn3460.ko $TARGET_PATH/

	fi
fi

echo "Update driver."
depmod -a

echo "Load module."
modprobe i2c_i801
modprobe i2c_dev
echo ptn3460 0x60 > /sys/bus/i2c/devices/i2c-$1/new_device

# Create rc.local file and start service
file=`ls /etc/rc.local`

if [ "$file" = "" ]; then

cat > /etc/rc.local <<EOF
#!/bin/sh
#
# rc.local
#
# This script is executed at the end of each multiuser runlevel.
# Make sure that the script will "exit 0" on success or any other
# value on error.
#
# In order to enable or disable this script just change the execution
# bits.
#
# By default this script does nothing.
 
exit 0
EOF

systemctl enable rc-local
systemctl start rc-local.service

fi

#Add modprobe to init


MODULE_INIT=$(grep -w "modprobe i2c_i801" /etc/rc.local)

	if [ "$MODULE_INIT" = "" ]; then
		sed -i '$d' /etc/rc.local
		echo modprobe i2c_i801 >> /etc/rc.local
		echo exit 0 >> /etc/rc.local
	fi

MODULE_INIT=$(grep -w "modprobe i2c_dev" /etc/rc.local)

	if [ "$MODULE_INIT" = "" ]; then
		sed -i '$d' /etc/rc.local
		echo modprobe i2c_dev >> /etc/rc.local
		echo exit 0 >> /etc/rc.local
	fi

MODULE_INIT=$(grep -w "echo ptn3460 0x60 > /sys/bus/i2c/devices/i2c-$1/new_device" /etc/rc.local)
	
	if [ "$MODULE_INIT" = "" ]; then
		sed -i '$d' /etc/rc.local
		echo "echo ptn3460 0x60 > /sys/bus/i2c/devices/i2c-$1/new_device" >> /etc/rc.local
		echo exit 0 >> /etc/rc.local
	fi


chmod +x /etc/rc.local

echo "Completed."
exit 0

