#!/bin/sh

title()
{
	echo -----------------------------------------
	echo "Install AAEON Fxxx GPIO Driver."
	echo -----------------------------------------
}

show_usage()
{
	echo "install.sh <chip name number [0-2]>\n"
	echo "0: f75113\n"
	echo "1: f81866\n"
	echo "2: f81966\n"
	echo "3: f81801\n"
}

if [ \( $# -eq 0 \) -o \( $# -gt 1 \) ] ; then
    show_usage
    echo "ERROR: incorrect number of parameters\n"
    exit 255
fi

title

echo "Check old driver and unload it."
check=`lsmod | grep -w gpio_fxxx`
if [ "$check" != "" ]; then
	echo "rmmod gpio_fxxx"
    /sbin/rmmod gpio_fxxx
fi


echo "Build the module and install."
echo "-------------------------------" >> log.txt
date 1>>log.txt
make all 1>>log.txt || exit 1

module=`ls driver/*.ko`
module=${module#driver/}
module=${module%.ko}

if [ "$module" = "" ]; then
	echo "No driver exists!!!"
	exit 1
else
	OLD_DRIVER=$(find /lib/modules/$(uname -r)/kernel/drivers/gpio -iname gpio-fxxx.ko -type f)
	BAK_DRIVER=$(find /lib/modules/$(uname -r)/kernel/drivers/gpio -iname gpio-fxxx.ko_bak -type f)
	TARGET_PATH=/lib/modules/$(uname -r)/kernel/drivers/gpio
	
	if [ "$BAK_DRIVER" = "" ]; then
	
		if [ "$OLD_DRIVER" = "" ]; then
			cp driver/gpio-fxxx.ko $TARGET_PATH/
		else
			mv $OLD_DRIVER $TARGET_PATH/gpio-fxxx.ko_bak
			cp driver/gpio-fxxx.ko $TARGET_PATH/
		fi
	
	else
		
		cp driver/gpio-fxxx.ko $TARGET_PATH/
		
	fi
fi

echo "Update driver."
depmod -a

echo "Load module: $module ."
modprobe $module chip_num=$1

#Add modprobe to init

echo "Add driver to init."
MODULE_INIT=$(grep -w "modprobe gpio-fxxx chip_num=$1" /etc/rc.local)
	
	if [ "$MODULE_INIT" = "" ]; then
		sed -i '$d' /etc/rc.local
		echo modprobe gpio-fxxx chip_num=$1 >> /etc/rc.local
		echo exit 0 >> /etc/rc.local
	fi

chmod +x /etc/rc.local

echo "Completed."
exit 0

