#!/bin/sh

show_usage()
{
   printf "gpiotest_XXX.sh <gpio pin number[0-7]> <in|out>\n"
}

if [ \( $# -eq 0 \) -o \( $# -gt 3 \) ] ; then
    show_usage
    printf "\n\nERROR: incorrect number of parameters\n"
    exit 255
fi

if [ $1 -gt 7 ] || [ $1 -lt 0 ] ; then
    show_usage
    echo "\n\nERROR: incorrect number of parameters\n"
    exit 255
fi

if [ \( "$2" != "in" \) -a  \( "$2" != "out" \) ] ; then
    show_usage
    printf "\n\nERROR: second parameter must be 'in' or 'out'\n"
    exit 255
fi

PORT=$1

if [ $1 -eq 0 ] ; then        #port:80
    PORT=80
elif [ $1 -eq 1 ] ; then      #port:81
    PORT=81
elif [ $1 -eq 2 ] ; then      #port:82
    PORT=82
elif [ $1 -eq 3 ] ; then      #port:83
    PORT=83
elif [ $1 -eq 4 ] ; then      #port:84
    PORT=84
elif [ $1 -eq 5 ] ; then      #port:85
    PORT=85
elif [ $1 -eq 6 ] ; then      #port:86
    PORT=86
elif [ $1 -eq 7 ] ; then      #port:87
    PORT=87
fi

#doesn't hurt to export a gpio more than once
if [ -d "/sys/class/gpio/gpio$PORT" ] ; then
    echo "GPIO has been exported."
else
    echo $PORT > /sys/class/gpio/export
fi

if [  $# -eq 1 ] ; then
   cat /sys/class/gpio/gpio$PORT/direction
   cat /sys/class/gpio/gpio$PORT/value
   exit 0
fi

echo $2 > /sys/class/gpio/gpio$PORT/direction

if [  $# -eq 2 ] ; then
   cat /sys/class/gpio/gpio$PORT/direction
   cat /sys/class/gpio/gpio$PORT/value
   exit 0
fi

VAL=$3

if [ $VAL -ne 0 ] ; then
    VAL=1
fi

echo $VAL > /sys/class/gpio/gpio$PORT/value
cat /sys/class/gpio/gpio$PORT/direction
cat /sys/class/gpio/gpio$PORT/value

exit 0